*_____________________________________________________________________________________________________________________________________________________
*
**# FIRST THINGS
*_____________________________________________________________________________________________________________________________________________________

clear
use "${elsadir}\H_ELSA.dta", replace


*_____________________________________________________________________________________________________________________________________________________
*
**# MERGING IN OTHER DATA
*_____________________________________________________________________________________________________________________________________________________

/* Seeing which waves var is available in:
	forvalues wave = 1/7 {
		local var heeye hefrnd hepap* 
		capture des `var' using "${elsaw`wave'}"
		if _rc==0	{
			dis _newline(5) "Wave is `wave'"
			des `var' using "${elsaw`wave'}"
		/**/ }
	/**/ }
*/

/* Mergeing in: 
	w2 weight - HRS file it's not technically a cross-sectional weight, but looking at documentation, I think it will do...
	Benefit claim vars 
	Health vars for Boheim-Leoni (mainly back pain version)
*/
sort idauniq 
forvalues wave = 1/7  {
						merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'all) keepusing(heill helim indobyr fqend heeye hefrnd hepap hehear) 			
	if `wave'==1 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'1)   keepusing(aeducend   /*disability bens*/ iahdb iahdr0? iahdn0? ialy ialy? ialy10 ialm ialm? ialm10 /*partner report*/ iahdp0? iahpn0? ialy2? ialy30 ialm3? ialm30) 			
	if `wave'==2 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'2)   keepusing(w2wgt 		/*disability bens*/ iahdb iahdr?  iahdn?  ialy ialy? 	    ialm ialm? 		  /*partner report*/ iahdp?  iahdpn? ialy19 ialy2? ialm19 ialm2?) 		
	if `wave'>=2		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'2up) keepusing(helwk) 	
	if `wave'==3 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'3)   keepusing(			/*disability bens*/ iahdb iahdr?? iahdn?? 									  /*partner report*/ iahdp?? iahdpn??) 					
	if `wave'>=3 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'3up) keepusing(hepain hepawba hepawhi hepawkn hepawfe hepawmo hepawot hepawal) 			
	if `wave'==4 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'4)   keepusing(			/*disability bens*/ iahdb iahdr?? iahdn?? ialy ialy?						  /*partner report*/ iahdp?? iahdpn?? ialy19 ialy2?) 					
	if `wave'>=5 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'5up) keepusing(fffqend	/*disability bens*/ iahdbc iahdn??  								 	 	  /*partner report*/ iahdpn??) 					
	if inlist(`wave', 1, 3, 4, 5) 		merge 1:1 idauniq using "${elsaw`wave'}", gen(_merge`wave'5ed) keepusing(*edqual) 					
	rename (he* ia* indobyr f*end) (r`wave'he* r`wave'ia* r`wave'indobyr r`wave'f*end)
	capture rename aeducend r`wave'aeducend
	* Matching w1 to w2 disability benefit names
	capture rename *iahdr0? *iahdr?
	capture rename *iahdn0? *iahdn?
	capture rename *iahdp0? *iahdp? 
	capture rename *iahpn0? *iahpn? 
/**/ }
drop _merge*
ren w2wgt r2cwtresp
rename edqual 	w1edqual
rename w?edqual	r?edqual
numlabel edqual w3edqual w4edqual w5edqual, mask(#_) add


// Merging in derived financial variables data
sort idauniq 
forvalues wave = 1/7  {
	dis "This is wave `wave'"
						merge 1:1 idauniq using "${elsadatadir}\wave_`wave'_financial_derived_variables", gen(_mergefin_w`wave'all) keepusing(icb_r_i icb_r_t sda_r_i sda_r_t attall_r_i attall_r_t dla_r_i dla_r_t ssp_r_i ssp_r_t indinj_r_i indinj_r_t war_r_i war_r_t oth1_r_i oth1_r_t)
	rename (icb_r_i icb_r_t sda_r_i sda_r_t attall_r_i attall_r_t dla_r_i dla_r_t ssp_r_i ssp_r_t indinj_r_i indinj_r_t war_r_i war_r_t oth1_r_i oth1_r_t) r`wave'=
	if `wave'==1 		{
		merge 1:1 idauniq using "${elsadatadir}\wave_`wave'_financial_derived_variables", gen(_mergefin_w`wave'_w`wave'only) keepusing(dptc_r_i dptc_r_t invcare_r_i invcare_r_t) 			
		rename (dptc_r_i dptc_r_t invcare_r_i invcare_r_t) r`wave'=
	/**/ }
	if inlist(`wave', 2, 3, 4) 		{
		merge 1:1 idauniq using "${elsadatadir}\wave_`wave'_financial_derived_variables", gen(_mergefin_w`wave'_w`wave'only) keepusing(carers_r_i carers_r_t) 			
		rename (carers_r_i carers_r_t) r`wave'=
	/**/ }
	if inlist(`wave', 5, 6) 		{
		merge 1:1 idauniq using "${elsadatadir}\wave_`wave'_financial_derived_variables", gen(_mergefin_w`wave'_w`wave'only) keepusing(carers_r_i carers_r_t esa_r_i esa_r_t) 			
		rename (carers_r_i carers_r_t esa_r_i esa_r_t) r`wave'=
	/**/ }
	if inlist(`wave', 7) 		{
		merge 1:1 idauniq using "${elsadatadir}\wave_`wave'_financial_derived_variables", gen(_mergefin_w`wave'_w`wave'only) keepusing(carers_r_i carers_r_t esa_r_i esa_r_t pip_r_i pip_r_t) 
		rename (carers_r_i carers_r_t esa_r_i esa_r_t pip_r_i pip_r_t) r`wave'=
	/**/ }
/**/ }
drop _merge*


// Merging in nurse visit data - grip strength (peak flow considered incomparable)
sort idauniq
merge 1:1 idauniq using "${elsaw2_nurse}", gen(_merge2) keepusing(w2wtnur mmgs*) 			
	ren mmgs* r2mmgs*
	ren w2wtnur w2nurwt
merge 1:1 idauniq using "${elsaw4_nurse}", gen(_merge4) keepusing(w4nurwt mmgs*) 			
	ren mmgs* r4mmgs*
merge 1:1 idauniq using "${elsaw6_nurse}", gen(_merge6) keepusing(w6nurwt mmgs*) 			
	ren mmgs* r6mmgs*
drop _merge*
// The derived vars
foreach wave in 2 4 6 {
	egen r`wave'maxgrip = rowmax(r`wave'mmgsd1 r`wave'mmgsd2 r`wave'mmgsn1 r`wave'mmgsn2)
		replace r`wave'maxgrip = .o if r`wave'maxgrip==-1
		label var r`wave'maxgrip "w`wave' grip strength in kg (max of first 4 measures)"
	capture egen r`wave'gs_no_inj = anymatch(r`wave'mmgsprpa), values(1)			// Not done as in pain - w4/6
	capture egen r`wave'gs_no_inj = anymatch(r`wave'mmgspr1) , values(2)			// Not done as in pain - w2
		replace r`wave'gs_no_inj = . if missing(w`wave'nurwt)
		replace r`wave'gs_no_inj = 1 if r`wave'mmgssta==4							// Not done as unable to use both hands
		label var r`wave'gs_no_inj "No GS measure: R in pain or not able to use both hands"
/**/ }
drop r?mmgs*


*_____________________________________________________________________________________________________________________________________________________
*
**# ELSA-SPECIFIC VARS (before reshaping, as wave-specific)
* Education quickly first, but mostly about disability benefit claims
*_____________________________________________________________________________________________________________________________________________________


// Education
mvdecode r?edqual, mv(-9=.r\-8 -3=.d\-1=.n)
*egen hi_redqual 	= rowmin(r?edqual)		
egen first_redqual 	= rowfirst(r1edqual r3edqual r4edqual r5edqual)		// From checking, this is how RAND derive raedisced
recode first_redqual (7=.n)(6=.o)(3 4 5=3)(2=4)(1=5), gen(raedisced_new)
replace raedisced = raedisced_new if raedisced==.h
* Years of education
unab edyrvars: r1aeducend r*fqend 
capture egen raedend = rowmax(`edyrvars')
	label values raedend FqEnd
	label define FqEnd -2 "w4 Capi/Interview Error", modify
	label var raedend "Education: age left ft education (highest of all wave responses)"
/* Checks, as there's some weird responses in this variable...
unab edyrvars: r1aeducend r*fqend 
levelsof raedend
foreach i in `r(levels)' {
	dis _newline(10)
	tab1 `edyrvars' if raedend==`i', m
	local outlevel: label FqEnd `i'
	pause Value is `i' : `outlevel'
/**/ }
*/


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// Disability benefits receipt (claims-based; income-based is below after reshaping)
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

* Firstly making sure that the data refers to the respondent
tempfile workingfile 
save "`workingfile'", replace
forvalues wave = 1/7 {
	use "`workingfile'", replace
	tempfile partnerdata_w`wave'
	keep idauniq s`wave'idauniq r`wave'ia* 
	capture drop r`wave'iadl*		// Bits of the income & assets file that don't need merging
	ren (r`wave'ia* s`wave'idauniq) =_P
	ren idauniq s`wave'idauniq
	sort s`wave'idauniq
	save "`partnerdata_w`wave''", replace
/**/ }
use "`workingfile'", replace
forvalues wave = 1/7 {
	recode s`wave'idauniq (0=.n)
	sort s`wave'idauniq 
	merge m:1 s`wave'idauniq using "`partnerdata_w`wave''", gen(_merge_P`wave')		// This is an m:1 merge because some s`wave'idauniq is missing for some people in the master data
	drop if _merge_P`wave'==2
	compare idauniq s`wave'idauniq_P
	dis in red "Check that these match (this is the spouse ID from the spouse, i.e. it should match the respondent ID)"
	drop s`wave'idauniq_P
/**/ }
drop _merge_P*


* w1
* Making sure that variables refer to respondent's benefits not their partner's, if R is not financial respondent (see note in OneNote)
replace r1iahdb = r1iahdb_P if r1finr==0 & s1finr==1				// This is the only variable that will be consistent, but done just for transparency in the code
forvalues i = 1/4 {
	replace r1iahdr`i' = r1iahdp`i'_P if r1finr==0 & s1finr==1
	replace r1iahdn`i' = r1iahpn`i'_P if r1finr==0 & s1finr==1
/**/ }
replace r1iahdr5 = -1 if r1finr==0 & s1finr==1		// There's no 5th variable for people describing their partners (but only 1 response for people describing themselves)
replace r1iahdn5 = -1 if r1finr==0 & s1finr==1
drop r1*_P
* The derived variable
local benvars "ib sd sp aa dl ii wd ca dptc 95"		
foreach i in 1 2 3 4 5 6 7 8 9 95 {
	if `i'~=95			local ben = word("`benvars'", `i')
	if `i'==95			local ben = "95"
	egen r1benyr_`ben' = anymatch(r1iahdr?), values(`i')
		* The remaining code is just to set missingness correctly
		replace r1benyr_`ben' = .  if 				  r1iahdb== . 	
		replace r1benyr_`ben' = .n if 				  r1iahdb== -1 	
		replace r1benyr_`ben' = .d if r1iahdr1== -8 | r1iahdb== -8
		replace r1benyr_`ben' = .r if r1iahdr1== -9 | r1iahdb== -9
	egen r1bennow_`ben' = anymatch(r1iahdn?), values(`i')
		* The remaining code is just to set missingness correctly
		replace r1bennow_`ben' = .  if 				   r1iahdb== . 	
		replace r1bennow_`ben' = .n if 				   r1iahdb== -1 	
		replace r1bennow_`ben' = .d if r1iahdr1== -8 | r1iahdn1== -8 | r1iahdb== -8
		replace r1bennow_`ben' = .r if r1iahdr1== -9 | r1iahdn1== -9 | r1iahdb== -9
/**/ }


* w2 
* Making sure that variables refer to respondent's benefits not their partner's, if R is not financial respondent (see note in OneNote)
replace r2iahdb = r2iahdb_P if r2finr==0 & s2finr==1				// This is the only variable that will be consistent, but done just for transparency in the code
forvalues i = 1/4 {
	replace r2iahdr`i' = r2iahdp`i'_P  if r2finr==0 & s2finr==1
	replace r2iahdn`i' = r2iahdpn`i'_P if r2finr==0 & s2finr==1
/**/ }
replace r2iahdr5 = -1 if r2finr==0 & s2finr==1		// There's no 5th variable for people describing their partners (but only 1 response for people describing themselves)
replace r2iahdn5 = -1 if r2finr==0 & s2finr==1
drop r2*_P
* The derived variable
local benvars "ib sd sp aa dl ii wd ca 95"		
foreach i in 1 2 3 4 5 6 7 8 95 {
	if `i'~=95			local ben = word("`benvars'", `i')
	if `i'==95			local ben = "95"
	egen r2benyr_`ben' = anymatch(r2iahdr?), values(`i')
		* The remaining code is just to set missingness correctly
		replace r2benyr_`ben' = .  if 				  r2iahdb== . 	
		replace r2benyr_`ben' = .n if 				  r2iahdb== -1 	
		replace r2benyr_`ben' = .d if r2iahdr1== -8 | r2iahdb== -8
		replace r2benyr_`ben' = .r if r2iahdr1== -9 | r2iahdb== -9
	egen r2bennow_`ben' = anymatch(r2iahdn?), values(`i')
		* The remaining code is just to set missingness correctly
		replace r2bennow_`ben' = .  if 				   r2iahdb== . 	
		replace r2bennow_`ben' = .n if 				   r2iahdb== -1 	
		replace r2bennow_`ben' = .d if r2iahdr1== -8 | r2iahdn1== -8 | r2iahdb== -8
		replace r2bennow_`ben' = .r if r2iahdr1== -9 | r2iahdn1== -9 | r2iahdb== -9
/**/ }
	

* w3 & w4
* Making sure that variables refer to respondent's benefits not their partner's, if R is not financial respondent (see note in OneNote)
foreach wave in 3 4 {
	replace r`wave'iahdb = r`wave'iahdb_P if r`wave'finr==0 & s`wave'finr==1				// This is the only variable that will be consistent, but done just for transparency in the code
	local benvars "ib sd sp aa dl ii wd ca 95"		
	foreach ben in `benvars' {
		if "`ben'"=="95"		local benP = "85"
		else					local benP = "`ben'"
		replace r`wave'iahdr`ben' = r`wave'iahdp`ben'_P   if r`wave'finr==0 & s`wave'finr==1
		replace r`wave'iahdn`ben' = r`wave'iahdpn`benP'_P if r`wave'finr==0 & s`wave'finr==1
	/**/ }
/**/ }
drop r3*_P r4*_P
* The derived variable
foreach wave in 3 4 {
	rename r`wave'iahdr* 	r`wave'benyr_*
	rename r`wave'iahdn*	r`wave'bennow_*
	* The remaining code is just to set missingness correctly
	local benvars "ib sd sp aa dl ii wd ca 95"		
	foreach ben in `benvars' {
		replace r`wave'benyr_`ben' = .  if 				   		     r`wave'iahdb== . 	
		replace r`wave'benyr_`ben' = 0  if 					  		 r`wave'iahdb== 2 
		replace r`wave'benyr_`ben' = .n if 					   		 r`wave'iahdb== -1 	
		replace r`wave'benyr_`ben' = .d if r`wave'benyr_`ben'== -8 | r`wave'iahdb== -8
		replace r`wave'benyr_`ben' = .r if r`wave'benyr_`ben'== -9 | r`wave'iahdb== -9
		* Claiming now
		replace r`wave'bennow_`ben' = .  if 				   		   r`wave'iahdb== . 	
		replace r`wave'bennow_`ben' = 0  if r`wave'benyr_`ben'== 0 | r`wave'benyr_`ben'==.d | r`wave'benyr_`ben'==.r  | r`wave'iahdb== 2 
		replace r`wave'bennow_`ben' = .n if 				   		   r`wave'iahdb== -1 	
		replace r`wave'bennow_`ben' = .d if r`wave'bennow_`ben'== -8 | r`wave'benyr_`ben'== -8 | r`wave'iahdb== -8
		replace r`wave'bennow_`ben' = .r if r`wave'bennow_`ben'== -9 | r`wave'benyr_`ben'== -9 | r`wave'iahdb== -9
	/**/ }
/**/ }


// w5-w7
* Making sure that variables refer to respondent's benefits not their partner's, if R is not financial respondent (see note in OneNote)
foreach wave in 5 6 7 {
	replace r`wave'iahdbc = r`wave'iahdbc_P if r`wave'finr==0 & s`wave'finr==1				// This is the only variable that will be consistent, but done just for transparency in the code
	local benvars "ib es sd sp aa pi dl ii wd ca 95"	
	foreach ben in `benvars' {
		if !(`wave'<7 & "`ben'"=="pi") {		// pip is only introduced as a category for w7
			replace r`wave'iahdn`ben' = r`wave'iahdpn`ben'_P if r`wave'finr==0 & s`wave'finr==1
		/**/ }
	/**/ }
/**/ }
drop r5*_P r6*_P r7*_P
* The derived variable
foreach wave in 5 6 7 {
	rename r`wave'iahdn*	r`wave'bennow_*
	* The remaining code is just to set missingness correctly
	local benvars "ib es sd sp aa pi dl ii wd ca 95"	
	foreach ben in `benvars' {
		if !(`wave'<7 & "`ben'"=="pi") {		// pip is only introduced as a category for w7
			replace r`wave'bennow_`ben' = 0  if 					  	   r`wave'iahdbc== 2 
			replace r`wave'bennow_`ben' = .n if 					   	   r`wave'iahdbc== -1 	
			replace r`wave'bennow_`ben' = .d if r`wave'bennow_`ben'== -8 | r`wave'iahdbc== -8
			replace r`wave'bennow_`ben' = .r if r`wave'bennow_`ben'== -9 | r`wave'iahdbc== -9
		/**/ }
	/**/ }
/**/ }



// The combined vars based on actual responses to questions
forvalues wave = 1/7 {
	* Out of work benefits (Incapacity Benefit, Severe Disablement Allowance, Employment & Support Allowance)
	if `wave'>=5	egen r`wave'bennow_incap  = anymatch(r`wave'bennow_ib r`wave'bennow_sd r`wave'bennow_es) , values(1)
	else			egen r`wave'bennow_incap  = anymatch(r`wave'bennow_ib r`wave'bennow_sd 					), values(1)
	if `wave'>=5	replace r`wave'bennow_incap = . if r`wave'bennow_incap==0 & missing(r`wave'bennow_ib, r`wave'bennow_sd, r`wave'bennow_es)
	else 			replace r`wave'bennow_incap = . if r`wave'bennow_incap==0 & missing(r`wave'bennow_ib, r`wave'bennow_sd)
	* Plus other incapacity-related benefits, not conditional on being workless (Industrial Injuries, War Disablement)
	if `wave'>=5	egen r`wave'bennow_incap2  = anymatch(r`wave'bennow_ii r`wave'bennow_wd r`wave'bennow_ib r`wave'bennow_sd r`wave'bennow_es) , values(1)
	else			egen r`wave'bennow_incap2  = anymatch(r`wave'bennow_ii r`wave'bennow_wd r`wave'bennow_ib r`wave'bennow_sd 				 ), values(1)
	if `wave'>=5	replace r`wave'bennow_incap2 = . if r`wave'bennow_incap2==0 & missing(r`wave'bennow_ii, r`wave'bennow_wd, r`wave'bennow_ib, r`wave'bennow_sd, r`wave'bennow_es)
	else 			replace r`wave'bennow_incap2 = . if r`wave'bennow_incap2==0 & missing(r`wave'bennow_ii, r`wave'bennow_wd, r`wave'bennow_ib, r`wave'bennow_sd)
	* Extra cost benefits (Attendance Allowance, DLA, PIP)
	if `wave'==7	egen r`wave'bennow_costs = anymatch(r`wave'bennow_aa r`wave'bennow_dl r`wave'bennow_pi), values(1)
	else			egen r`wave'bennow_costs = anymatch(r`wave'bennow_aa r`wave'bennow_dl 				  ), values(1)
	if `wave'==7	replace r`wave'bennow_costs = . if r`wave'bennow_costs==0 & missing(r`wave'bennow_aa, r`wave'bennow_dl, r`wave'bennow_pi)
	else 			replace r`wave'bennow_costs = . if r`wave'bennow_costs==0 & missing(r`wave'bennow_aa, r`wave'bennow_dl)
	* Other benefits (Carer's Allowance/ICA, Disabled Person's Tax Credit, other)
	if `wave'==1	egen r`wave'bennow_other = anymatch(r`wave'bennow_ca r`wave'bennow_95 r`wave'bennow_dptc), values(1)
	else 			egen r`wave'bennow_other = anymatch(r`wave'bennow_ca r`wave'bennow_95 					), values(1)
	if `wave'==1	replace r`wave'bennow_other = . if r`wave'bennow_other==0 & missing(r`wave'bennow_ca, r`wave'bennow_95, r`wave'bennow_dptc)
	else 			replace r`wave'bennow_other = . if r`wave'bennow_other==0 & missing(r`wave'bennow_ca, r`wave'bennow_95)
/**/ }


// The combined vars based on ELSA derived income variables, including imputations
forvalues wave = 1/7 {
	* Out of work benefits (Incapacity Benefit, Severe Disablement Allowance, Employment & Support Allowance) - exc. sick pay, though this is available in the data
	gen r`wave'beninc2_dis  = ( 						((r`wave'icb_r_i>0    | r`wave'icb_r_t==-1) 	& ~missing(r`wave'icb_r_i)) | ///
	/**/												((r`wave'sda_r_i>0    | r`wave'sda_r_t==-1) 	& ~missing(r`wave'sda_r_i)) )
	if `wave'>=5	replace r`wave'beninc2_dis  = 1 if 	((r`wave'esa_r_i>0    | r`wave'esa_r_t==-1) 	& ~missing(r`wave'esa_r_i))
	replace r`wave'beninc2_dis = . if r`wave'beninc2_dis==0 & missing(r`wave'icb_r_i, r`wave'sda_r_i)
	if `wave'>=5	replace r`wave'beninc2_dis = . if r`wave'beninc2_dis==0 & missing(r`wave'esa_r_i)
	* Plus other incapacity-related benefits, not conditional on being workless (Industrial Injuries, War Disablement)
	gen r`wave'beninc2_dis2  = (r`wave'beninc2_dis==1  |  ///
	/**/												((r`wave'indinj_r_i>0 | r`wave'indinj_r_t==-1) 	& ~missing(r`wave'indinj_r_i)) | ///
	/**/												((r`wave'war_r_i>0    | r`wave'war_r_t   ==-1)	& ~missing(r`wave'war_r_i)) )
	replace r`wave'beninc2_dis2= . if missing(r`wave'beninc2_dis)
	* Extra cost benefits (Attendance Allowance, DLA, PIP)
	gen r`wave'beninc2_costs  = (						((r`wave'attall_r_i>0 | r`wave'attall_r_t==-1)	& ~missing(r`wave'attall_r_i)) | ///
	/**/												((r`wave'dla_r_i>0    | r`wave'dla_r_t   ==-1)	& ~missing(r`wave'dla_r_i)) )
	if `wave'>=7	replace r`wave'beninc2_costs = 1 if ((r`wave'pip_r_i>0    | r`wave'pip_r_t   ==-1)	& ~missing(r`wave'pip_r_i))
	replace r`wave'beninc2_costs = . if r`wave'beninc2_costs==0 & missing(r`wave'dla_r_i, r`wave'attall_r_i) 
	if `wave'>=7	replace r`wave'beninc2_costs = . if r`wave'beninc2_costs==0 & missing(r`wave'pip_r_i)
	* Other benefits (Carer's Allowance/ICA, Disabled Person's Tax Credit, other)
	gen r`wave'beninc2_other  = ( 						((r`wave'oth1_r_i>0	  | r`wave'oth1_r_t  ==-1)	& ~missing(r`wave'oth1_r_i)) ) 
	if `wave'==1	replace r`wave'beninc2_other = 1 if ((r`wave'dptc_r_i>0   | r`wave'dptc_r_t  ==-1)  & ~missing(r`wave'dptc_r_i))   | ///
													   ((r`wave'invcare_r_i>0 | r`wave'invcare_r_t==-1) & ~missing(r`wave'invcare_r_i))
	if `wave'>=2	replace r`wave'beninc2_other = 1 if ((r`wave'carers_r_i>0 | r`wave'carers_r_t==-1)  & ~missing(r`wave'carers_r_i))
	replace r`wave'beninc2_other = . if r`wave'beninc2_other==0 & missing(r`wave'oth1_r_i)
	if `wave'==1	replace r`wave'beninc2_other = . if r`wave'beninc2_other==0 & missing(r`wave'dptc_r_i, r`wave'invcare_r_i)
	if `wave'>=2	replace r`wave'beninc2_other = . if r`wave'beninc2_other==0 & missing(r`wave'carers_r_i)
/**/ }


*_____________________________________________________________________________________________________________________________________________________
*
**# RESHAPING TO LONG (NOT WIDE) FORMAT
*_____________________________________________________________________________________________________________________________________________________

// Renaming for consistency with SHARE
gen cid = "61"		// This is to generate a unique country ID, so that there are no duplicate IDs across countries
gen country = 61
gen survey = "ELSA"
gen mergeid = cid + idauniqc
	label var mergeid "Country ID + HHIDPN, to be unique across countries"
order mergeid, first

// Rehsaping
local crosswavevars	"ragender raedisced raedend survey country "
local keepvars 		"r*walk100a r*sita r*chaira r*climsa r*clim1a r*stoopa r*armsa r*pusha r*lifta r*dimea"
local keepvars 		"`keepvars' r*dressa r*walkra r*batha r*eata r*beda r*toilta r*mapa r*mealsa r*shopa r*phonea r*medsa r*moneya"	// ADLs/IADL
local keepvars 		"`keepvars' r*shlt r*shltf r*shlta r*shltaf r*heill r*helim r*helwk r*imrc r*dlrc r?maxgrip r?gs_no_inj" 
local keepvars 		"`keepvars' r*depres r*effort r*sleepr r*whappy r*flone r*fsad r*going r*enlife r*cesd r*cesdm"
local keepvars 		"`keepvars' r*hearte r*hibpe r*stroke r*diabe r*lunge r*arthre r*cancre r*hepain r*hepawba r*hepawhi r*hepawkn r*hepawfe r*hepawmo r*hepawot r*hepawal r*bmi" // Boheim-Leoni-related vars added Nov 2017
local keepvars 		"`keepvars' r*psyche r*asthmae r*hchole r*parkine r*catrcte r*hipe"												// Condiitons added for OECD work
local keepvars 		"`keepvars' r*lbrf_e r*work r*jhours r*jhour2_e r*jweeks_e r*itearn r*itifearn r?issdi r?ifssdi"
local keepvars 		"`keepvars' inw? r?cwtresp r?scwtresp r?finr r*proxy r?agey r?child r?mstat r*iwindy r?indobyr w?nurwt"
local keepvars 		"`keepvars' r*jlasty r*jlastm r?jcten"																								// Added for Boheim-Leoni collaboration
local keepvars 		"`keepvars' r*hehear r*heeye r*hefrnd r*hepap"																								// Added for 2023 OECD report
local keepvars 		"`keepvars' r*bennow_sp r*bennow_incap r*bennow_incap2 r*bennow_costs r*bennow_other" 	// Benefit claims - ELSA-specific vars not from Global Aging Data
local keepvars 		"`keepvars' r?beninc2_dis r?beninc2_dis2 r?beninc2_costs r?beninc2_other"				// Benefit claims - ELSA-specific income based
keep mergeid cid `keepvars' `crosswavevars'
local reshapevars = subinstr("`keepvars'", "*", "@", .)	   
local reshapevars = subinstr("`reshapevars'", "?", "@", .)	  
reshape long `reshapevars', i(mergeid) j(wave)




*_____________________________________________________________________________________________________________________________________________________
*
**# ELSA-SPECIFIC VARS (after reshaping)
* Disability benefits and health vars
*_____________________________________________________________________________________________________________________________________________________

// Changing names of disben receipt vars, as these included extra cost bens
rename rissdi rissdi_e


// Labelling disability vars
rename rbennow_sp rbennow_ssp 
label var rbennow_ssp 		"Currently claiming SSP"
label var rbennow_incap 	"Currently claiming incapacity ben (IB/SDA/(w5)ESA)"
label var rbennow_incap2 	"Currently claiming incapacity-related ben (IIDB/WDP+IB/SDA/(w5)ESA)"
label var rbennow_costs 	"Currently claiming extra costs ben (DLA/AA/(w7)PIP)"
label var rbennow_other		"Currently claiming other health-related ben (mainly ICA/CA)"
label var rbeninc2_dis		"Currently claiming incapacity ben(IB/SDA/(w5)ESA), from derived income vars"
label var rbeninc2_dis2 	"Currently claiming incapacity-related ben (IIDB/WDP+IB/SDA/(w5)ESA), from derived income vars"
label var rbeninc2_costs 	"Currently claiming extra costs ben (DLA/AA/(w7)PIP), from derived income vars"
label var rbeninc2_other	"Currently claiming other health-related ben (mainly ICA/CA), from derived income vars"
* The actual dvs are derived above


// Health/disability vars
label values rheill heill
label values rhelim helim
label values rhelwk helwk
numlabel heill helim helwk, mask(#_) add
ren rheill rlsi
	label var rlsi		"Long-term ill/disabled"
	recode rlsi (2=0)
ren rhelim rllsiB
	recode rllsiB (2=0)
	label var rllsiB	"Limited activities (ELSA)"
	replace rllsiB = rlsi if rlsi~=1
ren rhelwk		rwld
	label var rwld		"Health prob limits paid work"
	recode rwld (2=0)
label var rshltf "Position of SRH in SHARE/ELSA"
mvdecode rlsi rllsiB rwld, mv(-9=.r\-8=.d\-1=.n)


	
	
*_____________________________________________________________________________________________________________________________________________________
*
**# FINAL THINGS
*_____________________________________________________________________________________________________________________________________________________

// Tidying up
order _all, sequential
order wave, after(mergeid)
ren rcwtresp rwtresp
ren riwindy riwy

// Testing
version 14
table wave, c(count rwalk100a mean rwalk100a)

// For saving
compress
save "${elsadir}\ELSA_BB_${versno}.dta", replace
